//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 16:31:44 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: delta_fisette_c
//
//	==> Number of joints: 23
//
//	==> Function: F2 - Recursive Inverse Dynamics of tree-like MBS
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"

 
void mbs_invdyna(double *Qq,
MbsData *s, double tsim)
{
#include "mbs_invdyna_delta_fisette_c.h"

double *q, *qd, *qdd;
double *g, *m;
double **l, **In, **dpt, **frc, **trq;

q = s->q;
qd = s->qd;
qdd = s->qdd;

dpt = s->dpt;
l   = s->l;

m = s->m;
In  = s->In;

frc = s->frc;
trq = s->trq;
g = s->g;
 
// Trigonometric functions

S4 = sin(q[4]);
C4 = cos(q[4]);
S5 = sin(q[5]);
C5 = cos(q[5]);
S6 = sin(q[6]);
C6 = cos(q[6]);
S7 = sin(q[7]);
C7 = cos(q[7]);
S8 = sin(q[8]);
C8 = cos(q[8]);
S9 = sin(q[9]);
C9 = cos(q[9]);
S10 = sin(q[10]);
C10 = cos(q[10]);
S11 = sin(q[11]);
C11 = cos(q[11]);
S12 = sin(q[12]);
C12 = cos(q[12]);
S13 = sin(q[13]);
C13 = cos(q[13]);
S14 = sin(q[14]);
C14 = cos(q[14]);
S15 = sin(q[15]);
C15 = cos(q[15]);
S16 = sin(q[16]);
C16 = cos(q[16]);
S17 = sin(q[17]);
C17 = cos(q[17]);
S18 = sin(q[18]);
C18 = cos(q[18]);
S19 = sin(q[19]);
C19 = cos(q[19]);
S20 = sin(q[20]);
C20 = cos(q[20]);
S21 = sin(q[21]);
C21 = cos(q[21]);
S22 = sin(q[22]);
C22 = cos(q[22]);
S23 = sin(q[23]);
C23 = cos(q[23]);
 
// Augmented Joint Position Vectors

 
// Forward Kinematics

ALPHA33 = qdd[3]-g[3];
 
// Backward Dynamics

Fq121 = -frc[1][21]-frc[1][22]-frc[1][23];
Fq221 = -frc[2][21]-frc[2][22]*C22-frc[2][23]*C23+frc[3][22]*S22+frc[3][23]*S23;
Fq321 = -frc[3][21]-frc[2][22]*S22-frc[2][23]*S23-frc[3][22]*C22-frc[3][23]*C23;
Cq121 = -trq[1][21]-trq[1][22]-trq[1][23]+dpt[2][20]*(-frc[2][22]*S22-frc[3][22]*C22)+dpt[2][21]*(-frc[2][23]*S23-
 frc[3][23]*C23);
Cq221 = -trq[2][21]-trq[2][22]*C22-trq[2][23]*C23+trq[3][22]*S22+trq[3][23]*S23;
Cq321 = -trq[3][21]+frc[1][22]*dpt[2][20]+frc[1][23]*dpt[2][21]-trq[2][22]*S22-trq[2][23]*S23-trq[3][22]*C22-
 trq[3][23]*C23;
Cq120 = -trq[1][20]+Cq121*C21+Cq321*S21-Fq221*dpt[3][19];
Cq220 = -trq[2][20]+Cq221+dpt[3][19]*(Fq121*C21+Fq321*S21);
Cq320 = -trq[3][20]-Cq121*S21+Cq321*C21;
Cq319 = -Cq120*S20+Cq320*C20;
Fq116 = -frc[1][16]-frc[1][17]-frc[1][18];
Fq216 = -frc[2][16]-frc[2][17]*C17-frc[2][18]*C18+frc[3][17]*S17+frc[3][18]*S18;
Fq316 = -frc[3][16]-frc[2][17]*S17-frc[2][18]*S18-frc[3][17]*C17-frc[3][18]*C18;
Cq116 = -trq[1][16]-trq[1][17]-trq[1][18]+dpt[2][16]*(-frc[2][17]*S17-frc[3][17]*C17)+dpt[2][17]*(-frc[2][18]*S18-
 frc[3][18]*C18);
Cq216 = -trq[2][16]-trq[2][17]*C17-trq[2][18]*C18+trq[3][17]*S17+trq[3][18]*S18;
Cq316 = -trq[3][16]+frc[1][17]*dpt[2][16]+frc[1][18]*dpt[2][17]-trq[2][17]*S17-trq[2][18]*S18-trq[3][17]*C17-
 trq[3][18]*C18;
Cq115 = -trq[1][15]+Cq116*C16+Cq316*S16-Fq216*dpt[3][15];
Cq215 = -trq[2][15]+Cq216+dpt[3][15]*(Fq116*C16+Fq316*S16);
Cq315 = -trq[3][15]-Cq116*S16+Cq316*C16;
Cq314 = -Cq115*S15+Cq315*C15;
Fq111 = -frc[1][11]-frc[1][12]-frc[1][13];
Fq311 = -frc[3][11]-frc[2][12]*S12-frc[2][13]*S13-frc[3][12]*C12-frc[3][13]*C13;
Cq211 = -trq[2][11]-trq[2][12]*C12-trq[2][13]*C13+trq[3][12]*S12+trq[3][13]*S13;
Cq210 = -trq[2][10]+Cq211+dpt[3][11]*(Fq111*C11+Fq311*S11);
Fq18 = -frc[1][9]*C9-frc[3][9]*S9;
Fq38 = frc[1][9]*S9-frc[3][9]*C9;
Cq38 = trq[1][9]*S9-trq[3][9]*C9;
Fq16 = -frc[1][7]*C7-frc[3][7]*S7;
Fq36 = frc[1][7]*S7-frc[3][7]*C7;
Cq36 = trq[1][7]*S7-trq[3][7]*C7;
Fq14 = -frc[1][5]*C5-frc[3][5]*S5;
Fq34 = frc[1][5]*S5-frc[3][5]*C5;
Cq34 = trq[1][5]*S5-trq[3][5]*C5;
Fs13 = -frc[1][3]+qdd[1]*m[3];
Fs23 = -frc[2][3]+qdd[2]*m[3];
Fs33 = -frc[3][3]+m[3]*ALPHA33;
Fq13 = Fs13+frc[2][5]*S4+frc[2][7]*S6+frc[2][9]*S8+Fq14*C4+Fq16*C6+Fq18*C8;
Fq23 = Fs23-frc[2][5]*C4-frc[2][7]*C6-frc[2][9]*C8+Fq14*S4+Fq16*S6+Fq18*S8;
Fq33 = Fq34+Fq36+Fq38+Fs33;
 
// Symbolic model output

Qq[1] = Fq13;
Qq[2] = Fq23;
Qq[3] = Fq33;
Qq[4] = Cq34;
Qq[5] = -trq[2][5];
Qq[6] = Cq36;
Qq[7] = -trq[2][7];
Qq[8] = Cq38;
Qq[9] = -trq[2][9];
Qq[10] = Cq210;
Qq[11] = Cq211;
Qq[12] = -trq[1][12];
Qq[13] = -trq[1][13];
Qq[14] = Cq314;
Qq[15] = Cq215;
Qq[16] = Cq216;
Qq[17] = -trq[1][17];
Qq[18] = -trq[1][18];
Qq[19] = Cq319;
Qq[20] = Cq220;
Qq[21] = Cq221;
Qq[22] = -trq[1][22];
Qq[23] = -trq[1][23];

// Number of continuation lines = 1

}
